// GMSH script to generate the mesh for a simple 2d beam
// Documentation: https://gmsh.info/doc/texinfo/gmsh.html
// Author: Andrea Pavan
// Date: 09/02/2023


//parameters
l1 = 5.0;		//x domain size
l2 = 0.5;		//y domain size

surfaceMeshSize = 0.02;		//mesh size at the boundaries


//change geometry kernel
SetFactory("OpenCASCADE");


//-----------------------
//  geometry creation
//-----------------------

Point(1) = {0, 0, 0, surfaceMeshSize};
Point(2) = {l1, 0, 0, surfaceMeshSize};
Point(3) = {l1, l2, 0, surfaceMeshSize};
Point(4) = {0, l2, 0, surfaceMeshSize};

Line(1) = {1, 2};
Line(2) = {2, 3};
Line(3) = {3, 4};
Line(4) = {4, 1};

Curve Loop(1) = {1, 2, 3, 4};
Plane Surface(1) = {1};
